﻿#region: CMTraceLog Function formats logging in CMTrace style
        function CMTraceLog {
         [CmdletBinding()]
    Param (
		    [Parameter(Mandatory=$false)]
		    $Message,
		    [Parameter(Mandatory=$false)]
		    $ErrorMessage, 
		    [Parameter(Mandatory=$false)]
		    $Component, 
		    [Parameter(Mandatory=$false)]
		    [int]$Type,		
		    [Parameter(Mandatory=$true)]
		    $LogFile
	    )
    <#
    Type: 1 = Normal, 2 = Warning (yellow), 3 = Error (red)
    #>
	    $Time = Get-Date -Format "HH:mm:ss.ffffff"
	    $Date = Get-Date -Format "MM-dd-yyyy"
	    if ($ErrorMessage -ne $null) {$Type = 3}
	    if ($Component -eq $null) {$Component = " "}
	    if ($Type -eq $null) {$Type = 1}
	    $LogMessage = "<![LOG[$Message $ErrorMessage" + "]LOG]!><time=`"$Time`" date=`"$Date`" component=`"$Component`" context=`"`" type=`"$Type`" thread=`"`" file=`"`">"
	    $LogMessage.Replace("`0","") | Out-File -Append -Encoding UTF8 -FilePath $LogFile
    }


$tsenv = New-Object -ComObject Microsoft.SMS.TSEnvironment
$LogPath = $tsenv.Value('_SMSTSLogPath')
$LogFile = "$LogPath\WaaS_LangPack.log"


$Mode = $tsenv.Value('SMSTS_TSWaaSMode') #This Var is set at the start of each TS
if ($Mode -ne $null)
    {
    if ($Mode -eq "Upgrade")
    {
    $CurrentOSInfo = Get-Item -Path 'HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion'
    $ReleaseID_CurrentOS = $CurrentOSInfo.GetValue('ReleaseId')
    if ($ReleaseID_CurrentOS -eq $tsenv.Value('SMSTS_Build'))
        {
        $ComponetSuffix = "PostSetup"
        }
    Else
        {
        $ComponetSuffix = "PreSetup"
        }    
    $Component = "$($mode):LP:$($ComponetSuffix)"
    }
    Else
        {$Component = "$($mode):LP"}
    }
else {$Component = "LangCaps"}

Write-Output "-------------------------------------------"
Write-Output "Starting Language Capabilities Script"
CMTraceLog -Message  "Starting Language Capabilities Script" -Type 1 -LogFile $LogFile -Component $Component

#Create Temp Folder to copy all language files to for the Setup Engine to Consume
$WaaSLangPacksFolder = "$env:temp\WaaSLangPacks"
if (Test-Path -Path $WaaSLangPacksFolder){Remove-Item -Path $WaaSLangPacksFolder -Recurse -Force}
$NULL = New-Item -Path $WaaSLangPacksFolder -ItemType Directory -Force

$LangPackIDs = (New-Object -COMObject Microsoft.SMS.TSEnvironment).GetVariables() | Where-Object {$_ -Like "LANGPACKID_*"}

foreach ($LangPackID in $LangPackIDs){

    #Setting the Language Pack Path Variable LANGPACKID_FR-CA
    $TSCACHE = "_SMSTSPackageCacheLocation" + $tsenv.Value($LangPackID)
    $CCMCACHE = "_SMSTS" + $tsenv.Value($LangPackID)
    if ($tsenv.Value($TSCACHE)) {$WorkingPath = $tsenv.Value($TSCACHE)}
    if ($tsenv.Value($CCMCACHE)) {$WorkingPath = $tsenv.Value($CCMCACHE)}
    write-output "$LangPackID Files located $WorkingPath"
    Write-Output "Copying $WorkingPath to $WaaSLangPacksFolder"
    Copy-Item -Path "$WorkingPath\*" -Destination $WaaSLangPacksFolder -Recurse -Force -Verbose
    CMTraceLog -Message  " Working on $LangPackID - $($tsenv.Value($LangPackID))" -Type 1 -LogFile $LogFile -Component $Component
    CMTraceLog -Message  "  Copying $WorkingPath to $WaaSLangPacksFolder" -Type 1 -LogFile $LogFile -Component $Component
}

$tsenv.Value('LANG01') = $WaaSLangPacksFolder
write-output "LANG01:$($tsenv.Value('LANG01'))"
CMTraceLog -Message  "  LANG01:$($tsenv.Value('LANG01'))" -Type 1 -LogFile $LogFile -Component $Component
